/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InputType {
    UNDEFINED("undefined"),
    NONE("none"),
    SELECTION("selection"),
    SELECTED_LINES("selected_lines"),
    LINE("line"),
    WORD("word"),
    LEFT_CHAR("left_character"),
    RIGHT_CHAR("right_character"),
    DOCUMENT("document"),
    CLIPBOARD("clipboard"),
    INPUT_FROM_CONSOLE("input_from_console"),
    INPUT_FROM_FILE("input_from_file"),
    INPUT_FROM_STREAM("input_from_stream");

    private static final Map<String, InputType> NAME_MAP;
    private String _name;

    static {
        NAME_MAP = new HashMap<String, InputType>();
        for (InputType type : EnumSet.allOf(InputType.class)) {
            NAME_MAP.put(type.getName(), type);
        }
    }

    public static final InputType get(String name) {
        if (name == null) {
            return UNDEFINED;
        }
        return NAME_MAP.containsKey(name = name.toLowerCase()) ? NAME_MAP.get(name) : UNDEFINED;
    }

    private InputType(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }
}

